﻿//////////////////////////////////////////////
// CpuInformation.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkLog
#include <NilkinsMemory/Containers/String.h>

/// Enums ------------------------------------

namespace nkDebug
{
	enum class CPU_VENDOR
	{
		UNKNOWN = 0,
		AMD,
		INTEL
	} ;

	enum class CPU_ARCHITECTURE
	{
		UNKNOWN = 0,
		X_64,
		ARM,
		ARM_64
	} ;
}

/// Structs ----------------------------------

namespace nkDebug
{
	struct CpuInformation final
	{
		nkMemory::String _cpuLabel ;

		CPU_VENDOR _cpuVendor = CPU_VENDOR::UNKNOWN ;
		CPU_ARCHITECTURE _cpuArchitecture = CPU_ARCHITECTURE::UNKNOWN ;

		unsigned int _threadCount = 0u ;
	} ;
}